@echo off
rem *******************************************************************************
rem Make sure we are in the right directory
rem *******************************************************************************
if NOT exist .\PUSHCOPY.BAT GOTO WRONGDIR


rem *******************************************************************************
rem %1 = Destination Path
rem %2 = W98 or XP or Win32 or W2K
rem *******************************************************************************

if "%2"=="w98" goto Win9x
if "%2"=="W98" goto Win9x
if "%2"=="w2k" goto WIN2K
if "%2"=="W2K" goto WIN2K
if "%2"=="xp"  goto WINXP
if "%2"=="XP"  goto WINXP
if "%2"=="WS03"  goto WS03
if "%2"=="ws03"  goto WS03
if /I "%2"=="VISTA32" goto VISTA32
if /I "%2"=="VISTAX64" goto VISTAX64

goto Usage

rem *******************************************************************************
rem 	WIN98SE file copies
rem *******************************************************************************
:Win9x

rem *****************************************************
rem copy the base driver files for win98se
rem *****************************************************

md %1

rem 10/100 specific files
copy /v ..\..\..\PRO100\WIN98SE\*.* %1

rem Gigabit specific files
copy /v ..\..\..\PRO1000\WIN98SE\*.* %1

copy /v ..\..\TOOLS\DIAGS.EXE %1

rem *******************************************************************************
rem Copy MSBATCH.INF and CUSTOM.INF
rem *******************************************************************************
copy WIN98SE\*.inf            %1

rem *******************************************************************************
rem Copy the NDIS2 DOS driver so network connectivity can be re-established if necessary
rem *******************************************************************************
copy /v ..\..\..\PRO100\dos\e100bodi.com       %1

goto end

rem *******************************************************************************
rem 	WIN2K file copies
rem *******************************************************************************

:WIN2K
echo *** Win2K file copy

rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32

rem *************************************************************************
rem  Copy the base driver files
rem *************************************************************************

rem 10/100 specific files to the root OEM directory and to the specific 10/1000/OS directory (needed for setupBD)
copy ..\..\..\PRO100\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Win32

rem Gigabit specific files
copy ..\..\..\PRO1000\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32
del %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32\*60*.*

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\PROSetDX\Win32

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\PROSetDX\Win32\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Win32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy win2k\pushw2k.txt %1\$oem$\$1\drivers\net\INTEL
copy win2k\unattend.txt %1\$oem$\$1\drivers\net\INTEL
copy win2k\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatco.dll %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.sys %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.inf %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.cat %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32


Goto end

rem *******************************************************************************
rem 	WINXP file copies
rem *******************************************************************************
:WINXP
echo *** WinXP file copy

rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32

REM **********************************************************************
REM  COPY Base driver files for Windows XP
REM **********************************************************************

rem 10/100 specific files to the root OEM directory and to the specific 10/1000/OS directory (needed for setupBD)
copy ..\..\..\PRO100\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Win32

rem Gigabit specific files
copy ..\..\..\PRO1000\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32
del %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32\*60*.*

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Win32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy WS03XP32\Unattend.txt %1\$oem$\$1\drivers\net\INTEL
copy WS03XP32\Pushxp.txt %1\$oem$\$1\drivers\net\INTEL
copy WS03XP32\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatco.dll %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.sys %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.inf %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.cat %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32


Goto end


rem *******************************************************************************
rem 	WINDOWS SERVER 2003 file copies
rem *******************************************************************************
:WS03
echo *** Windows Server 2003 file copy

rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32

REM **********************************************************************
REM  COPY Base driver files for Windows Server 2003
REM **********************************************************************

rem 10/100 specific files
copy ..\..\..\PRO100\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Win32

rem Gigabit specific files
copy ..\..\..\PRO1000\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32
del %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32\*60*.*

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Win32\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Win32\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Win32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy WS03XP32\Unattend.txt %1\$oem$\$1\drivers\net\INTEL
copy WS03XP32\PushWs3.txt %1\$oem$\$1\drivers\net\INTEL
copy WS03XP32\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatco.dll %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.sys %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.inf %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.cat %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32

Goto end

rem *******************************************************************************
rem 	WINDOWS Vista 32 file copies
rem *******************************************************************************
:VISTA32
echo *** Windows Vista 32 file copy
rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Vista32
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Vista32\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Vista32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Win32
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Win32

REM **********************************************************************
REM  COPY Base driver files for Windows Vista
REM **********************************************************************

rem 10/100 specific files
copy ..\..\..\PRO100\Win32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Win32

rem Gigabit specific files
copy /Y ..\..\..\PRO1000\Win32\*60*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32
copy /Y ..\..\..\PRO1000\Win32\*.DLL %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32
copy /Y ..\..\..\PRO1000\Win32\*.exe %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Win32

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Vista32\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Vista32

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Vista32\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Vista32\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Vista32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Vista32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy Vista32\PushV32.txt %1\$oem$\$1\drivers\net\INTEL
copy Vista32\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Win32\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Win32

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Win32 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatco.dll %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.sys %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.inf %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32
copy /v ..\..\..\PLATFORM\IOATDMA\Win32\ioatdma.cat %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Win32

Goto end

rem *******************************************************************************
rem 	WINDOWS Vista 32e file copies
rem *******************************************************************************
:VISTAX64
echo *** Windows Vista 32e file copy
rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Vistax64
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Vistax64\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\Vistax64
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\Winx64
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\Winx64

REM **********************************************************************
REM  COPY Base driver files for Windows Vista
REM **********************************************************************

rem 10/100 specific files
copy ..\..\..\PRO100\Winx64\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\Winx64

rem Gigabit specific files
copy /Y ..\..\..\PRO1000\Winx64\*60*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Winx64
copy /Y ..\..\..\PRO1000\Winx64\*.DLL %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Winx64
copy /Y ..\..\..\PRO1000\Winx64\*.exe %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\Winx64

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\Vistax64\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Vistax64

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\Vistax64\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\Vistax64\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\Vistax64\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\Vistax64

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy VistaX64\PushVx64.txt %1\$oem$\$1\drivers\net\INTEL
copy VistaX64\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\INTELAMT\DRIVERS\Winx64 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Winx64
copy ..\..\..\PLATFORM\INTELAMT\DRIVERS\Winx64\*.*  %1\$oem$\$1\drivers\net\INTEL\PLATFORM\INTELAMT\DRIVERS\Winx64

REM *******************************************************************************
REM Copy the Intel I/O Acceleration Technology drivers
REM *******************************************************************************
if not exist ..\..\..\PLATFORM\IOATDMA\Winx64 goto end
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA
md %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64
copy /v ..\..\PLATFORM\IOATDMA\Winx64\ioatco.dll %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64
copy /v ..\..\..\PLATFORM\IOATDMA\Winx64\ioatdma.sys %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64
copy /v ..\..\..\PLATFORM\IOATDMA\Winx64\ioatdma.inf %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64
copy /v ..\..\..\PLATFORM\IOATDMA\Winx64\ioatdma.cat %1\$oem$\$1\drivers\net\INTEL\PLATFORM\IOATDMA\Winx64

Goto end

:WRONGDIR
echo.
echo.
echo PUSHCOPY must be run from the \APPS\SETUP\PUSH directory on the CD or 
echo CD image to work properly.  
echo.
echo  Please change directories to the \APPS\SETUP\PUSH directory before running PUSHCOPY.
echo.
echo.


:Usage
echo.
echo Invalid Command Line Argument
echo.
echo Usage Rules:
echo pushcopy [Destination Path] [OS]
echo where [destination] is the drive letter and path (such as Z:)
echo       Do not add a trailing backslash (\) to the destination path. 
echo [OS]    	= OS family
echo W98     	= Microsoft Windows 98 and Windows 98SE*
echo W2K     	= Microsoft Windows* 2000
echo XP      	= Microsoft Windows XP*
echo WS03    	= Microsoft Windows Server 2003*
echo VISTA32		= Microsoft Windows Vista* 32 bit
echo VISTAX64	= Microsoft Windows Vista* x64
echo.

:end
